-- Configure the server for CLR operation
sp_configure 'clr enabled', 1
GO
reconfigure
GO


-- Drop objects
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChangeEncoding]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ChangeEncoding]
GO
IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N'Jet.DataManager.Functions')
DROP ASSEMBLY [Jet.DataManager.Functions]
GO


-- Import CLR assembly
CREATE ASSEMBLY [Jet.DataManager.Functions]
FROM 'C:\Program Files\Jet Data Manager\Jet.DataManager.Functions.dll'
WITH PERMISSION_SET = SAFE
GO


-- Create function from assembly
CREATE FUNCTION [dbo].[ChangeEncoding] (@Input nvarchar(4000), @SourceCodePage int, @TargetCodePage int)
RETURNS nvarchar(4000)
AS EXTERNAL NAME [Jet.DataManager.Functions].[Jet.DataManager.Functions.UserDefinedFunctions].[ChangeEncoding];
GO